{--------------------------------------------------------------------}
{ Plasma Effect Demo in Text Mode                                    }
{ Written by Bayu Prasetio - 1998                                    }
{ E-Mail: bit_byte@hotmail.com                                       }
{ URL: http://www.geocities.com/SiliconValley/Horizon/5108           }
{--------------------------------------------------------------------}
{$S-}

uses CRT;

const BR=80;  {count of coloumns         }
      H =50;  {count of rows             }
      DE=100; {delay time in mili seconds}
     
var TAB           :array[1..2,0..255]of byte;
    X,Y           :byte;
    A,AA,B,BB,C,I :byte;

{------------------------------------------------------------------------}
{                                                LOGO                    }
{------------------------------------------------------------------------}
Procedure LOGO;
var ch :char;
BEGIN
  writeln('Plasma Effect Demo in Text Mode.');
  writeln('Written by Bayu Prasetio - 1998.');
  writeln;
  write('Choose the color intensity. Low (8 colors) or High (16 colors) [L/H] ? ');
  
  repeat
    ch:=upcase(readkey);
  until ch in ['L','H'];
  
  if (ch='L') then I:=8
    else I:=16; 
END;

{------------------------------------------------------------------------}
{                                                INITPLASMA              }
{------------------------------------------------------------------------}
procedure INITPLASMA;
BEGIN
  for X:=0 to 255 do begin
    TAB[1,X]:=round(sin(2*pi*X/255)*128)+128;
    TAB[2,X]:=round(cos(2*pi*X/255)*128)+128;
  END;
  A:=20;
  B:=80;
END;

{------------------------------------------------------------------------}
{                                                DOPLASMA                }
{------------------------------------------------------------------------}
procedure DOPLASMA;
var OFFSS         :word;
BEGIN
  ASM
    sub  A,1
    add  B,2
  END;
  for Y:=0 to H-1 do begin
    AA:=TAB[1,(Y+A) mod 255];
    BB:=TAB[1,B mod 255];
    X:=0;
    repeat;
      C:=TAB[1,(X+AA) mod 255]+TAB[2,(Y+BB) mod 255];
      C:=C mod I;
      OFFSS:=(Y*BR+X)shl 1;
      mem[$b800:OFFSS]:=219;
      mem[$b800:OFFSS+1]:=C;
      inc(X);
    until X>=BR;
  END;
END;

{------------------------------------------------------------------------}
{                                                MAIN                    }
{------------------------------------------------------------------------}

BEGIN
  ASM
    mov ax,3h
    int 10h
  END;
  LOGO; 
  ASM
    mov  ax,1112h
    mov  bl,0h
    int  10h
  END;
  INITPLASMA;

  repeat
    DOPLASMA;
    delay(DE);
  until keypressed;
  
  ASM
    mov ax,3h
    int 10h
  END; 
END.

{------------------------------------------------------------------------}
{                                                END OF FILE             }
{------------------------------------------------------------------------}
