{---------------------------------------------------
 In the Name of Allah, Most Gracious, Most Merciful
----------------------------------------------------
 Komponen  : TStartBtn
 versi     : 1.03 yang telah disempurnakan
 Kegunaan  : - Memanipulasi Start Button di Win32
               (Enable, Visible, Ganti Logo "Start")
 Dibuat    : Ramadhan 1420 H
----------------------------------------------------
 O l e h   : Bayu Prasetio
 E-mail    : bayu@members.mikrodata.co.id
 * Bug, komentar, pertanyaan, silahkan email saya.
----------------------------------------------------
 Copyright (C) 1999 - 2000 , Dark Logic Corp.
---------------------------------------------------}

unit StartBtn;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics;

type
  // definisikan jenis perataan teks
  TCaptionAlignment = (caLeft, caCenter, caRight);

  // definisikan jenis logo yang akan dipakai
  // - lkText berarti logo dalam bentuk teks
  // - lkBitmap berarti logo diambil dari file .bmp
  TLogoKind = (lkText, lkBitmap);

  TStartBtn = class(TComponent)
  private
    { Private declarations }
    FAlignment: TCaptionAlignment;
    FCaption: String;
    FColor: TColor;
    FEnabled: Boolean;
    FHandle: THandle;
    FKind : TLogoKind;
    FVisible: Boolean;

    FBmp: TBitmap;
    FBitmapFile: String;
    FHOriginalBitmap: THandle;
    FSBRect: TRect;

    procedure DrawBtn;
    function GetFont: TFont;
    procedure SetAlignment(Value: TCaptionAlignment);
    procedure SetCaption(Value: String);
    procedure SetColor(Value: TColor);
    procedure SetEnabled(Value: Boolean);
    procedure SetFont(Value: TFont);
    procedure SetVisible(Value: Boolean);
  protected
    { Protected declarations }
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure LoadFromFile(FileName: String);
    procedure Refresh(LogoKind: TLogoKind);
    procedure Restore;
    property LogoKind: TLogoKind read FKind;
  published
    { Published declarations }
    property Alignment: TCaptionAlignment read FAlignment write SetAlignment;
    property Caption: String read FCaption write SetCaption;
    property Color: TColor read FColor write SetColor;
    property Enabled: Boolean read FEnabled write SetEnabled;
    property Font: TFont read GetFont write SetFont;
    property Visible: Boolean read FVisible write SetVisible;
  end;

procedure Register;

implementation

{------------- Konstruktor TStartBtn --------------}
constructor TStartBtn.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FAlignment := caCenter;
  FCaption := 'HALO';
  FColor := clBtnFace;
  FEnabled := True;
  FKind := lkText;
  FVisible := True;
  FBitmapFile := '';

  // simpan handle bitmap start button yang asli
  FHandle := FindWindowEx(FindWindow('Shell_TrayWnd', nil), 0, 'Button', nil);
  FHOriginalBitmap := SendMessage(FHandle, BM_GETIMAGE, IMAGE_BITMAP, 0);

  // inisialisasi bitmap penampung
  FBmp := TBitmap.Create;
  with FBmp.Canvas do
  begin
    with Font do
    begin
      Name := 'Arial';
      Size := 10;
      Style := [fsBold];
      Color := clBtnText;
    end;
    Brush.Color := FColor;
  end;
end;

{-------------- Destruktor TStartBtn --------------}
destructor TStartBtn.Destroy;
begin
  FBmp.Free;
  inherited Destroy;
end;

{------------- rutin penggambar logo --------------}
procedure TStartBtn.DrawBtn;
begin
 // cek apakah aplikasi sedang dalam mode perancangan
 if not(csDesigning in ComponentState) then
 begin
  FHandle := FindWindowEx(FindWindow('Shell_TrayWnd', nil), 0, 'Button', nil);
  if FKind = lkText then
  begin
    // sesuaikan lebar bitmap dengan lebar Start Button
    Windows.GetClientRect(FHandle, FSBRect);
    FBmp.Width := FSBRect.Right;
    FBmp.Height := FSBRect.Bottom;

    // siapkan kanvas dan latar belakang
    FBmp.Canvas.Brush.Color := FColor;
    FBmp.Canvas.FillRect(FSBRect);

    // gambar teks berdasarkan perataan
    case FAlignment of
      caLeft   : Windows.DrawText(FBmp.Canvas.Handle,
                                  PChar(FCaption),
                                  -1,
                                  FSBRect,
                                  DT_LEFT or DT_VCENTER or DT_SINGLELINE);

      caCenter : Windows.DrawText(FBmp.Canvas.Handle,
                                  PChar(FCaption),
                                  -1,
                                  FSBRect,
                                  DT_CENTER or DT_VCENTER or DT_SINGLELINE);

      caRight  : Windows.DrawText(FBmp.Canvas.Handle,
                                  PChar(FCaption),
                                  -1,
                                  FSBRect,
                                  DT_RIGHT or DT_VCENTER or DT_SINGLELINE);
    end;
  end;
  // ubah akselerator bitmap dengan bitmap buatan sendiri
  SendMessage(FHandle, BM_SETIMAGE, 0, FBmp.Handle);
 end;
end;

{-------------- dapatkan jenis font ---------------}
function TStartBtn.GetFont: TFont;
begin
  Result := FBmp.Canvas.Font;
end;

{--------------- set perataan teks ----------------}
procedure TStartBtn.SetAlignment(Value: TCaptionAlignment);
begin
  if Value <> FAlignment then
  begin
    FAlignment := Value;
    FKind := lkText;
    DrawBtn;
  end;
end;

{-------------- set caption / title ---------------}
procedure TStartBtn.SetCaption(Value: String);
begin
  if Value <> FCaption then
  begin
    FCaption := Value;
    FKind := lkText;
    DrawBtn;
  end;
end;

{---------------- set warna button ----------------}
procedure TStartBtn.SetColor(Value: TColor);
begin
  if Value <> FColor then
  begin
    FColor := Value;
    FKind := lkText;
    DrawBtn;
  end;
end;

{------------- set enable / disable ---------------}
procedure TStartBtn.SetEnabled(Value: Boolean);
begin
  if Value <> FEnabled then FEnabled := Value;
  EnableWindow(FHandle, FEnabled);
end;

{-------------- set font pada teks ----------------}
procedure TStartBtn.SetFont(Value: TFont);
begin
  if Value <> FBmp.Canvas.Font then
  begin
    FBmp.Canvas.Font := Value;
    FKind := lkText;
    DrawBtn;
  end;
end;

{------------- set penampakan button --------------}
procedure TStartBtn.SetVisible(Value: Boolean);
begin
  if Value <> FVisible then FVisible := Value;
  if FVisible then
    ShowWindow(FHandle, SW_SHOW)
  else
    ShowWindow(FHandle, SW_HIDE);
end;

{---------- panggil bitmap buatan sendiri ---------}
procedure TStartBtn.LoadFromFile(FileName: String);
begin
  if FileName <> FBitmapFile then
  begin
    FBitmapFile := FileName;
    FBmp.LoadFromFile(FileName);
    FKind := lkBitmap;
    DrawBtn;
  end;
end;

{---------------- gambar ulang logo ---------------}
procedure TStartBtn.Refresh(LogoKind: TLogoKind);
begin
  if LogoKind = lkBitmap then  // jenis logo = bitmap ?
    if FBitmapFile <> '' then  // file bitmap telah dimuat ?
      FBmp.LoadFromFile(FBitmapFile) // gambar kembali file bitmap
    else
    begin
      FBmp.Canvas.Brush.Color := clBtnFace; // gambar bitmap tanpa teks
      FBmp.Canvas.FillRect(FSBRect);        // latar belakang default
    end;
  FKind := LogoKind;
  DrawBtn;
end;

{------------ restore logo ke aslinya -------------}
procedure TStartBtn.Restore;
begin
  SendMessage(FHandle, BM_SETIMAGE, 0, FHOriginalBitmap);
end;

{-------------- daftarkan komponen ----------------}
procedure Register;
begin
  RegisterComponents('TaskBar', [TStartBtn]);
end;

end.