// -----------------------------------------------------------------------
// TStartBtn Demo..(make your start button looks cool)
// Change Start button color, font, text, etc.
// Require TStartBtn component v1.03 or above
// For more powerful implementation, use Start Toys v1.5x or above
// -----------------------------------------------------------------------
// TStartBtn and Start Toys are written and (c) by Bayu Prasetio
// Free distributed but no warranty.
// Any changes, please let me know
// Any feedbacks send to bayu@members.mikrodata.co.id
// Get lastest version @ http://www11.ewebcity.com/bayup
// Copyright (c) 1999 - 2001, Bayu Prasetio
// -----------------------------------------------------------------------

unit main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, StartBtn;

type
  TDemoForm = class(TForm)
    StartBtn1: TStartBtn;
    StartTextEdit: TEdit;
    ChangeBtn: TButton;
    VisibleBox: TCheckBox;
    EnableBox: TCheckBox;
    RestoreBtn: TButton;
    CloseBtn: TButton;
    Label1: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure ChangeBtnClick(Sender: TObject);
    procedure VisibleBoxClick(Sender: TObject);
    procedure EnableBoxClick(Sender: TObject);
    procedure RestoreBtnClick(Sender: TObject);
    procedure CloseBtnClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  DemoForm: TDemoForm;

implementation

{$R *.DFM}

procedure TDemoForm.FormCreate(Sender: TObject);
begin
  // synchronize Stat button with form properties
  StartTextEdit.Text := StartBtn1.Caption;
  VisibleBox.Checked := StartBtn1.Visible;
  EnableBox.Checked := StartBtn1.Enabled;
end;

procedure TDemoForm.ChangeBtnClick(Sender: TObject);
begin
  // change 'Start' text
  StartBtn1.Caption := StartTextEdit.Text;
end;

procedure TDemoForm.VisibleBoxClick(Sender: TObject);
begin
  // change start button visibility
  StartBtn1.Visible := VisibleBox.Checked;
end;

procedure TDemoForm.EnableBoxClick(Sender: TObject);
begin
  // enable / disable start button
  StartBtn1.Enabled := EnableBox.Checked;
end;

procedure TDemoForm.RestoreBtnClick(Sender: TObject);
begin
  // restore to original 'Start' text
  StartBtn1.Restore;
end;

procedure TDemoForm.CloseBtnClick(Sender: TObject);
begin
  Close;
end;

end.
