{*********************************************************************
 *     File                    : AsahOtak.PAS                        *
 *     Programmer              : Bayu Prasetio                       *
 *     First Programmed        : Semarang, July 1997                 * 
 *     New Released            : January  1998                       *
 *     Compiler                : Turbo Pascal 7.0                    *
 *     Thanks 2                : - ALLAH S.W.T.                      *
 *                               - Parrents                          *
 *                                                                   *
 *-------------------------------------------------------------------*
 *     Copyright  (c)  1997  -  BIT_BYTE Technology                  *
 *********************************************************************}

uses crt,dos;

type s = array [1..25,1..40] of record
              kar  : char;
              attr :byte;
         end;

label ulang,selesai;

var i,j,x,y,b1,b2,b3,
    k1,k2,k3,d1,d2         : integer;
    m                      : array [1..3,1..3] of byte;
    ch                     : char;
    r                      : registers;
    allright,keluar,mulai,
    reset                  : boolean;
    btanya                 : s absolute $b800:0;
    sv                     : s;

{*********************************************************************
 --------------   Procedure - procedure pembantu   -------------------
 *********************************************************************}


procedure hidecur;
begin
    r.cx:=$800;
    r.ah:=1;
    intr($10,r);
end;

procedure setcur;
begin
    r.cx:=$607;
    r.ah:=1;
    intr($10,r);
end;

function cek_isi(x,y:integer) : byte;
begin
    gotoxy(x,y);
    r.ah:=8;
    r.bh:=0;
    intr($10,r);
    cek_isi:=r.al-48;
end;

procedure writexy(x,y,h:integer;b:byte;st:string);
begin gotoxy(x,y);
      if h=0 then write(b);
      if h=1 then write(st);
      if h=2 then write(st,b);
      hidecur;
end;

procedure hlight(l,x:integer);
begin if l=0 then textcolor(12) else textcolor(10);
      case x of
      1,2,3  :  for i:= 1 to 3 do writexy(12+i*4,8+x*2,0,m[x,i],'');
      4,5,6  :  for i:= 1 to 3 do writexy(x*4,8+i*2,0,m[i,x-3],'');
      else      for i:= 1 to 3 do
                if x=7 then writexy(12+i*4,8+i*2,0,m[i,i],'')
                       else writexy(28-i*4,8+i*2,0,m[i,4-i],'');
      end;
end;


{*********************************************************************
 -------------   Procedure pembuatan kotak permainan    --------------
 *********************************************************************}


procedure create_sq;
begin textmode(c40);textcolor(15);textbackground(15);
      writexy(1,1,1,0,'ͻ');
      writexy(1,2,1,0,'          Asah Otak 9 Kotak           ');
      writexy(1,3,1,0,'     (c) 1997,98 - Bayu Prasetio      ');
      writexy(1,4,1,0,'Ķ');
      textbackground(10);
      for i:=5 to 19 do
      begin writexy(1,i,1,0,'');
            for j:=2 to 39 do writexy(j,i,1,0,'');
            writexy(40,i,1,0,'');
      end;
      textbackground(8);
      writexy(1,20,1,0,'');writexy(40,20,1,0,'');
      for i:=2 to 39 do writexy(i,20,1,0,'');
      for i:=21 to 24 do
      begin writexy(1,i,1,0,'');writexy(40,i,1,0,'');
            for j:=2 to 39 do writexy(j,i,1,0,' ');
      end;
      writexy(1,24,1,0,'ͼ');
      textcolor(14);
      writexy(14,20,1,0,' Tombol fungsi ');
      writexy(3,21,1,0,'Panah : Mengubah posisi');
      writexy(3,22,1,0,'Enter : Menetapkan / mengunci posisi');
      writexy(3,23,1,0,'Alt+R : Reset         Esc   : Keluar');
      window(9,6,31,18);
      textbackground(9);textcolor(0);
      clrscr;window(1,1,40,25);
      writexy(9,6,1,0,'ͻ');
      writexy(9,18,1,0,'ͼ');
      for i:=7 to 17 do
      begin writexy(9,i,1,0,'');writexy(31,i,1,0,'');
      end;
      writexy(13,8,1,0,'          ');
      writexy(13,16,1,0,'          ');
      for i:=1 to 3 do
      begin writexy(13,8+i*2,1,0,#17);
            gotoxy(27,8+i*2);
                r.ax:=$910;
                r.bx:=$10;
                r.cx:=1;
                intr($10,r);

      end;
      textbackground(15);
      writexy(14,9,1,0,'ͻ');
      for i:=1 to 3 do writexy(14,i*2+8,1,0,'         ');
      for i:=1 to 2 do writexy(14,i*2+9,1,0,'Ķ');
      writexy(14,15,1,0,'ͼ');
end;


{*********************************************************************
 ----------------------------  Otak  Program   -----------------------
 *********************************************************************}

procedure read_sq;

begin y:=10; allright:=false;
      for i:= 1 to 3 do
      begin x:=16;
            for J:= 1 to 3 do
            begin m[i,j]:=cek_isi(x,y);
                  x:=x + 4;
            end;
            y:=y + 2;
      end;

      b1:=m[1,1]+m[1,2]+m[1,3]; {baris I}
      b2:=m[2,1]+m[2,2]+m[2,3];
      b3:=m[3,1]+m[3,2]+m[3,3];
      k1:=m[1,1]+m[2,1]+m[3,1]; {kolom I}
      k2:=m[1,2]+m[2,2]+m[3,2];
      k3:=m[1,3]+m[2,3]+m[3,3];
      d1:=m[1,1]+m[2,2]+m[3,3]; {diagonal I}
      d2:=m[1,3]+m[2,2]+m[3,1];

      textcolor(12);
      if b1 > 9 then
        begin writexy(11,10,0,b1,'');writexy(28,10,0,b1,'');
      end else
        begin writexy(11,10,2,b1,' ');writexy(28,10,2,b1,' ');
        end;

      if b2 > 9 then
        begin writexy(11,12,0,b2,'');writexy(28,12,0,b2,'');
        end else
        begin writexy(11,12,2,b2,' ');writexy(28,12,2,b2,' ');
        end;

      if b3 > 9 then
        begin writexy(11,14,0,b3,'');writexy(28,14,0,b3,'');
        end else
        begin writexy(11,14,2,b3,' ');writexy(28,14,2,b3,' ');
        end;


      if k1 > 9 then
        begin writexy(15,7,0,k1,'');writexy(15,17,0,k1,'');
        end else
        begin writexy(15,7,2,k1,' ');writexy(15,17,2,k1,' ');
        end;

      if k2 > 9 then
        begin writexy(19,7,0,k2,'');writexy(19,17,0,k2,'');
        end else
        begin writexy(19,7,2,k2,' ');writexy(19,17,2,k2,' ');
        end;

      if k3 > 9 then
        begin writexy(23,7,0,k3,'');writexy(23,17,0,k3,'');
        end else
        begin writexy(23,7,2,k3,' ');writexy(23,17,2,k3,' ');
        end;

      if d1 > 9 then
      begin writexy(11,7,0,d1,'');writexy(28,17,0,d1,'')
      end else
      begin writexy(11,7,2,d1,' ');writexy(28,17,2,d1,' ');
      end;

      if d2 > 9 then
      begin writexy(11,17,0,d2,'');writexy(28,7,0,d2,'');
      end else
      begin writexy(11,17,2,d2,' ');writexy(28,7,2,d2,' ');
      end;

      if (b1=b2) and (b2=b3) and (k1=k2) and (k2=k3) and (d1=d2)
         then allright:=true else allright:=false;
end;

{*********************************************************************
 ------------- Mengubah posisi angka yang telah dipilih --------------
 *********************************************************************}

procedure rotate(p,turn:integer);
var k:byte;
begin  case p of
          1,2,3 : case turn of
                   1 : for k:=1 to 3 do
                       if k=1 then writexy(16,p*2+8,0,m[p,3],'')
                       else writexy(12+k*4,p*2+8,0,m[p,k-1],'');

                   2 : for k:=1 to 3 do
                       if k=3 then writexy(24,p*2+8,0,m[p,1],'')
                       else writexy(12+k*4,p*2+8,0,m[p,k+1],'');
                  end;

          4,5,6 : case turn of
                   1 : for k:=1 to 3 do
                       if k=1 then writexy(p*4,10,0,m[3,p-3],'')
                       else writexy(p*4,8+k*2,0,m[k-1,p-3],'');

                   2 : for k:=1 to 3 do
                       if k=3 then writexy(p*4,14,0,m[1,p-3],'')
                       else writexy(p*4,8+k*2,0,m[k+1,p-3],'');
                  end;

          7     : case turn of
                   1 : for k:=1 to 3 do
                       if k=1 then writexy(16,10,0,m[3,3],'')
                       else writexy(12+k*4,8+k*2,0,m[k-1,k-1],'');

                   2 : for k:=1 to 3 do
                       if k=3 then writexy(24,14,0,m[1,1],'')
                       else writexy(12 +k*4,8+k*2,0,m[k+1,k+1],'');
                  end;

          8     : case turn of
                   1 : for k:=1 to 3 do
                       if k=3 then writexy(16,14,0,m[1,3],'')
                       else writexy(28-4*k,8+k*2,0,m[k+1,3-k],'');

                   2 : for k:=1 to 3 do
                       if k=1 then writexy(24,10,0,m[3,1],'')
                       else writexy(28-4*k,8+k*2,0,m[k-1,5-k],'');
                  end;
          end;
          read_sq;
end;

{*********************************************************************
 ************   Procedure untuk menyiapkan angka - angka   ***********
 *********************************************************************}
procedure prepare_number;
var n,l : byte;
begin n:=1; textcolor(12);
      for i:=1 to 3 do
      for j:=1 to 3 do
      begin writexy(j*4+12,i*2+8,0,n,'');
            n:=n+1;
      end;
      read_sq;

      { Pengacak posisi }
      randomize;l:=0;
      while l=0 do l:=random(10);
      for n:=1 to l do
      if odd(n) then
      begin rotate(n,1);
            read_sq;
      end else
      begin rotate(n,2);
            read_sq;
      end;
end;


{*********************************************************************
 --------- Mendeteksi input , penanganan perpindahan angka  ----------
 *********************************************************************}

procedure pilih;
var t,q,tes : integer;

begin t:=1;hlight(1,t);keluar:=false;reset:=false;
      repeat
        ch:=readkey;
        case ch of
          #77,#80 : begin hlight(0,t);t:=t+1;
                          if t=9 then t:=1;
                          hlight(1,t);
                    end;

          #72,#75 : begin hlight(0,t);t:=t-1;
                          if t=0 then t:=8;
                          hlight(1,t);
                    end;
          end;

          tes:=t;
      until (ch=#13) or (ch=#27) or (ch=#19);
      if ch=#19 then reset:=true;
      if ch=#27 then keluar:= true;
      if ch=#13 then
      repeat
        ch:=readkey;q:=0;
        if tes>7 then
          case ch of
           #72,#77 : q:=1;
           #75,#80 : q:=2;
          end
        else
          case ch of
           #77,#80 : q:=1;
           #72,#75 : q:=2;
          end;
        rotate(tes,q);hlight(1,tes);
      until ch=#13;
      hlight(0,tes);
end;


{*********************************************************************
 --------------------  Procedure cetak keberhasilan  -----------------
 *********************************************************************}

procedure ask;
begin sv:=btanya;mulai:=false;keluar:=false;
      writexy(1,21,1,0,'ͻ');
      writexy(1,22,1,0,' Anda berhasil. Main lagi [Y/T] ?   ');
      writexy(1,23,1,0,'ͼ');
      write(#7);
      repeat  ch:=upcase(readkey);
      until ch in ['Y','T'];writexy(36,22,1,0,ch);
      if ch='Y' then mulai:=true else keluar:=true;
      btanya:=sv;
end;


{*********************************************************************
 -------------------------  Program  utama   -------------------------
 *********************************************************************}

begin create_sq;
      ulang : prepare_number;
              if allright then goto ulang;

              repeat pilih;
              until allright or keluar or reset;

              if reset then goto ulang;
              if keluar then goto selesai;
              if allright then
              begin ask;
                    if mulai then goto ulang;
                    if keluar then goto selesai;
              end;

      selesai : textmode(c80);textattr:=7;
                setcur;halt(0);
end.

{*********************************************************************
 -------------------- End Of File AsahOtak.PAS -----------------------
 *********************************************************************}
