; SetDVer v1.23a (the best version) - Utility to change DOS version
; Written by Bayu Prasetio - Jun 1998
; Thanks to Alpha in Jeys 354 Computer
; Serial number : PROJ/1/B/04/06/1998 
; (C) Dark Logic - 1998

Code Segment
     Assume CS:Code, DS:Code, ES:Code, SS:Code
     Org 100h

Listing : Jmp Begin

OldInt9h_Off  dw ?                           ; Original int 9h address
OldInt9h_Seg  dw ?

OldInt21h_Off dw ?                           ; Original int 21h address
OldInt21h_Seg dw ?

NewInt9h :
         push ax
         push ds
         mov  ax,40h
         mov  ds,ax
         mov  al,byte ptr ds:[17h]           ; Get code in keyboard flags
         pop  ds
         and  al,7                           ; CTRL and SHIFT toggle on  
         cmp  al,5  
         je   CheckPlusMin
         cmp  al,6
         je   CheckPlusMin

Exit9h : pop  ax
         jmp  dword ptr cs:OldInt9h_Off      ; Jump to origin int 9h address  

CheckPlusMin :
         in   al,60h                         ; Get code with keyboard port
         cmp  al,4eh                         ; Plus (keypad) key
         je   PlusKey
         cmp  al,4ah                         ; Minus (keypad) key
         je   Minuskey
         cmp  al,53h                         ; Delete key
         jne  Exit9h

Normal : mov  cs:VerPos,10                   ; Restore DOS version
         jmp  short Exit9h
        
Minuskey: 
         cmp  cs:VerPos,0                    ; Compare DOS version with bottom
         ja   MinusIt                        ; bound address
         jmp  short Exit9h

PlusKey :
         cmp  cs:VerPos,9                    ; Compare DOS version with top
         jb   PlusIt                         ; bound address
         jmp  short Exit9h

MinusIt :Dec  cs:VerPos                      ; Decrement DOS version 
         jmp  short Exit9h

PlusIt  :Inc  cs:VerPos                      ; Increment DOS version
         jmp  short Exit9h


NewInt21h :                                  ; Now, we're intercepting int 21h
          cmp  ah,30h                        ; Function 30h
          jnz  Exit21h
          pushf
          push bx
          mov  bh,0
          mov  bl,cs:VerPos                   ; Manipulate the DOS version
          shl  bl,1
          mov  ax,cs:DOSVer+bx                ; Give the DOS version output
          pop  bx
          popf
          Iret
Exit21h :
          jmp  dword ptr cs:OldInt21h_Off

VerPos    db  8                               ; Actual DOS version address 
DOSVer    dw  0001h,0002h,0003h,0A03h         ; Data of DOS version that can be
          dw  1E03h,0004h,0005h,0006h         ; accessed and manipulated
          dw  1406h,1606h
OriginVer dw  ?                               ; Original DOS version 
EndOfResident:

Copyright db ' SetDVer v1.23a - A TSR utility to change the DOS version.',13,10
          db ' Written by Bayu Prasetio - May 1998.',13,10
          db ' Copyright (C) Dark Logic - 1998. All rights reserved.'
          db 13,10,13,10,'$'

Already   db 'SetDVer is already installed in memory.',7,13,10,13,10,'$'

Install   db 'To change DOS version, just press CTRL+SHIFT+<option>',13,10
          db 'The option : ',13,10
          db '--> Plus Key (+) at keypad to increase DOS version.',13,10
          db '--> Minus Key (-) at keypad to decrease DOS version.',13,10
          db '--> Delete Key (Del) to restore DOS version.',13,10
          db 13,10
          db 'DOS version allowed :',13,10
          db ' 1.00           2.00           3.00           3.10',13,10
          db ' 3.30           4.00           5.00           6.00',13,10
          db ' 6.20           6.22',13,10
          db 'Good luck, and have a nice day !!!!',13,10,13,10,'$'

Begin : 
        lea  dx,Copyright                    ; Show copyright
        mov  ah,9
        int  21h
               
        mov  ax,35F1h                        ; Check for existing this utility  
        int  21h                             ; in memory
        cmp  bx,0DCABh
        jne  GoInstall

        lea  dx,Already                      ; Program is installed in memory
        mov  ah,9
        int  21h
        lea  dx,Install
        int  21h

        mov  ah,4ch                          
        int  21h                             ; Exit to DOS

GoInstall :
        mov  ah,30h                           
        int  21h
        mov  OriginVer,ax                    ; Save original DOS version

        mov  ax,3509h                        ; Get and save int 9h address
        int  21h
        mov  OldInt9h_Off,bx
        mov  OldInt9h_Seg,es
        mov  ax,2509h                        ; Set new int 9h address
        lea  dx,NewInt9h
        int  21h

        mov  ax,3521h                        ; Get and save int 21h address
        int  21h
        mov  OldInt21h_Off,bx
        mov  OldInt21h_Seg,es
        mov  ax,2521h                        ; Set new int 21h address				
        lea  dx,NewInt21h
        int  21h

        mov  ax,25F1h                        ; Set new int f1h address
        mov  dx,0DCABh
        int  21h

        lea  dx,Install          
        mov  ah,9
        int  21h

        lea  dx,EndOfResident            
        mov  cl,4
        shr  dx,cl
        inc  dx
        mov  ax,3100h
        int  21h                             ; Make resident
        
        
Code    ends
        end Listing

;------------- Now, the listing ends here. Compile, link and run soon --------























